/*  Project leowl_6
    xor@frognet.net
    Copyright  1996. Andrey B. Yastrebov. All Rights Reserved.

    SUBSYSTEM:    leowl_6.exe Application
    FILE:         leowl_6.cpp
    AUTHOR:       Andrey B. Yastrebov


    OVERVIEW
    ========
    Source file for implementation of leowl_6 (TApplication).
*/


#include <owl\owlpch.h>
#include <owl\docview.h>
#include <owl\filedoc.h>
#include <owl\editview.h>
#include <owl\listview.h>
#include <owl\docmanag.h>
#pragma hdrstop

#include "leowl_6.h"
#include "leowl_6e.h"


//{{leowl_6 Implementation}}



//{{DOC_VIEW}}
DEFINE_DOC_TEMPLATE_CLASS(TFileDocument, leowl_6Edit, DocType1);
DEFINE_DOC_TEMPLATE_CLASS(TFileDocument, TEditView, DocType2);
DEFINE_DOC_TEMPLATE_CLASS(TFileDocument, TListView, DocType3);
//{{DOC_VIEW_END}}

//{{DOC_MANAGER}}
DocType1 __dvt1("LEdit View", "*.*", 0, "TXT", dtAutoDelete | dtUpdateDir);
DocType2 __dvt2("Windows Edit View", "*.*", 0, "TXT", dtAutoDelete | dtUpdateDir);
DocType3 __dvt3("List View", "*.*", 0, "TXT", dtAutoDelete | dtUpdateDir);
//{{DOC_MANAGER_END}}


//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(leowl_6, TApplication)
//{{leowl_6RSP_TBL_BEGIN}}
	 EV_OWLVIEW(dnCreate, EvNewView),
	 EV_OWLVIEW(dnClose,  EvCloseView),
//{{leowl_6RSP_TBL_END}}
END_RESPONSE_TABLE;


//////////////////////////////////////////////////////////
// leowl_6
// =====
//
leowl_6::leowl_6 () : TApplication("leowl_6")
{
	 SetDocManager(new TDocManager(dmMDI));
}


leowl_6::~leowl_6 ()
{
}


//////////////////////////////////////////////////////////
// leowl_6
// =====
// Application intialization.
//
void leowl_6::InitMainWindow ()
{
    if (nCmdShow != SW_HIDE)
        nCmdShow = (nCmdShow != SW_SHOWMINNOACTIVE) ? SW_SHOWNORMAL : nCmdShow;

    mdiClient = new TMDIClient(this);
    TDecoratedMDIFrame* frame = new TDecoratedMDIFrame(Name, MDI_MENU,
		*mdiClient, FALSE, this);

    nCmdShow = (nCmdShow != SW_SHOWMINNOACTIVE) ? SW_SHOWNORMAL : nCmdShow;

    //
    // Assign ICON w/ this application.
    //
    frame->SetIcon(this, IDI_MDIAPPLICATION);

    //
    // Menu associated with window and accelerator table associated with table.
    //
    frame->AssignMenu(MDI_MENU);

    //
    // Associate with the accelerator table.
    //
    frame->Attr.AccelTable = MDI_MENU;


    SetMainWindow(frame);

	 frame->SetMenuDescr(TMenuDescr(MDI_MENU,1,2,1,0,1,0));

}


//////////////////////////////////////////////////////////
// leowl_6
// =====
// Response Table handlers:
//
void leowl_6::EvNewView (TView& view)
{
    TMDIClient *mdiClient = TYPESAFE_DOWNCAST(GetMainWindow()->GetClientWindow(),
      TMDIClient);
    if (mdiClient)
      {
        TMDIChild* child = new TMDIChild(*mdiClient, 0, view.GetWindow());


        int IconType = IDI_MDIAPPLICATION;
        if (typeid(view) == typeid(TListView))
            IconType = IDI_DOCLIST;
        else if (typeid(view) == typeid(TEditView))
            IconType = IDI_DOCEDIT;
        else if (typeid(view) == typeid(leowl_6Edit))
            IconType = IDI_DOC;

        // Associate ICON w/ this child window.
        child->SetIcon(this, IconType);

        child->Create();
    }
}


void leowl_6::EvCloseView (TView&)
{
}

int OwlMain (int , char* [])
{
    try {
        leowl_6    app;
        return app.Run();
    }
    catch (xmsg& x) {
        ::MessageBox(0, x.why().c_str(), "Exception", MB_OK);
    }

    return -1;
}
